import { ChatSendAfterEvent, ItemUseAfterEvent, ItemUseOnAfterEvent, Player } from "@minecraft/server";

export class CommandJ{
    /**
     * A class with custom command data
     * @param {string} id Command name
     * @param {string} desc Command description
     * @param {Function} exe Command function / callback
     * @param {Array} par Additional function arguments
     */
    constructor(id, desc, exe, par){
        this.id = id, this.desc = desc, this.func = exe, this.args = par
    };
    /**
     * @description Array containing all custom commands
     * @type {Array<CommandJ>}
     */
    static storage = [];
    /**
     * Run the command as a selected player using certain data
     * @param {Player} player Player executing the command
     * @param {string} dataType The chatevent data to use
     * @param {ItemUseAfterEvent|ItemUseOnAfterEvent|ChatSendAfterEvent|undefined} data The itemevent data to use
     * @param {JSON|undefined} additional More data put manually
     */
    run(player, dataType, data, additional){ this.func(player, dataType, data, additional); };
    /**
     * Registers this command so it can be used - important!
     */
    registerCommand(){ CommandJ.storage.push(this) }
}
